// Author: gre
// License: MIT

/*{
  "DESCRIPTION": "FlyEye transition",
  "CREDIT": "gre",
  "ISFVSN": "2",
  "CATEGORIES": [
    "Transition"
  ],
  "INPUTS": [
    {
      "NAME": "transitionBeginImage",
      "TYPE": "image"
    },
    {
      "NAME": "transitionEndImage",
      "TYPE": "image"
    },
    {
      "NAME": "size",
      "TYPE": "float",
      "DEFAULT": 0.04,
      "MIN": 0.0,
      "MAX": 1.0
    },
    {
      "NAME": "zoom",
      "TYPE": "float",
      "DEFAULT": 50.0,
      "MIN": 0.0,
      "MAX": 100.0
    },
    {
      "NAME": "colorSeparation",
      "TYPE": "float",
      "DEFAULT": 0.3,
      "MIN": 0.0,
      "MAX": 1.0
    }
  ]
}*/

#define getFromColor(uv) IMG_NORM_PIXEL(transitionBeginImage, uv)
#define getToColor(uv) IMG_NORM_PIXEL(transitionEndImage, uv)
#define progress transitionProgress

uniform float transitionProgress;
vec4 transition(vec2 uv);

void main()
{
  gl_FragColor = transition(isf_FragNormCoord);
}

vec4 transition(vec2 p) {
  float inv = 1. - progress;
  vec2 disp = size*vec2(cos(zoom*p.x), sin(zoom*p.y));
  vec4 texTo = getToColor(p + inv*disp);
  vec4 texFrom = vec4(
    getFromColor(p + progress*disp*(1.0 - colorSeparation)).r,
    getFromColor(p + progress*disp).g,
    getFromColor(p + progress*disp*(1.0 + colorSeparation)).b,
    1.0);
  return texTo*progress + texFrom*inv;
}
